/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.gravestones.gravestones;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import net.pneumono.gravestones.gravestones.GravestoneManager;
import net.pneumono.gravestones.gravestones.GravestoneTime;
import net.pneumono.gravestones.gravestones.RecentGraveHistory;
import net.pneumono.gravestones.multiversion.VersionUtil;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

public class GravestoneDataSaving
extends GravestoneManager {
    protected static void saveBackup(class_2487 contents, class_1657 player) {
        GravestoneDataSaving.saveBackup(contents, player, new Date());
    }

    protected static void saveBackup(class_2487 contents, class_1657 player, Date date) {
        String uuidString = VersionUtil.getId(player.method_7334()).toString();
        File deathsFile = new File(GravestoneDataSaving.getOrCreateGravestonesFolder(Objects.requireNonNull(MultiVersionUtil.getWorld((class_1297)player).method_8503())), uuidString);
        deathsFile.mkdirs();
        Path path = deathsFile.toPath().resolve(GravestoneTime.FILE_SAVING.format(date) + ".dat");
        int count = 1;
        while (path.toFile().exists()) {
            path = deathsFile.toPath().resolve(GravestoneTime.FILE_SAVING.format(date) + "_" + ++count + ".dat");
        }
        class_2487 deathData = new class_2487();
        deathData.method_10566("contents", (class_2520)contents);
        try {
            class_2507.method_30614((class_2487)deathData, (File)path.toFile());
        }
        catch (IOException e) {
            GravestoneDataSaving.error("Failed to write Gravestone Contents Data", e);
        }
    }

    public static List<RecentGraveHistory> readHistories(MinecraftServer server) {
        Path path = GravestoneDataSaving.getOrCreateGravestonesDataFile(server);
        class_2487 compound = new class_2487();
        try {
            compound = class_2507.method_30613((File)path.toFile());
        }
        catch (IOException e) {
            GravestoneDataSaving.error("Failed to read Gravestone Data", e);
        }
        return VersionUtil.get(compound, "data", RecentGraveHistory.CODEC.listOf()).orElse(new ArrayList());
    }

    public static void writeData(MinecraftServer server, List<RecentGraveHistory> histories) {
        Path path = GravestoneDataSaving.getOrCreateGravestonesDataFile(server);
        class_2487 compound = new class_2487();
        VersionUtil.put(compound, "data", RecentGraveHistory.CODEC.listOf(), histories);
        try {
            class_2507.method_30614((class_2487)compound, (File)path.toFile());
        }
        catch (IOException e) {
            GravestoneDataSaving.error("Failed to write Gravestone Data", e);
        }
    }

    public static Path getOrCreateGravestonesDataFile(MinecraftServer server) {
        File gravestoneFile = GravestoneDataSaving.getOrCreateGravestonesFolder(server);
        return gravestoneFile.toPath().resolve("data.dat");
    }

    public static File getOrCreateGravestonesFolder(MinecraftServer server) {
        File gravestonesFile = new File(server.method_27050(class_5218.field_24188).toString(), "gravestones");
        gravestonesFile.mkdirs();
        return gravestonesFile;
    }
}

